capture log close
clear all
macro drop _all
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Sensitivity Analysis - TNSP\Stata - Sensitivity Analysis\Stata Data Mgt"
set more off
log using Output/log/crTNSPbench25-firm, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics 2025 TNSP Benchmarking - Sensitivity Analysis
Author:  Michael Cunningham
File:    crTNSPbench24-firm1.do
Initial Date:    30-May-2022
Revised Date:	 21-Aug-2025
--------------------------------------------------------------------------*/

local varlist revenue energy customers maxdemand ratchetmd circlength ens ///
	price_ens opex price_opex overline undercable transform auc_overline ///
	auc_undercable auc_transform  	
	
scalar define reliabilitycap = 0.025
scalar define minens  = 0.2	

*--------------------------------------------------------------------------

import excel using "Input/TNSP_MTFP_modelling_20250819_SenAna_Capacity.xlsm", ///
  sheet("Shazam TNSP Data") firstrow cellrange(A1:S97) case(l) clear
drop in 1
destring, replace
describe, f	

rename tnspyearidentifier			  tnspyear
rename totalrevenue                   revenue
rename maximumdemand                  maxdemand
rename ratchetedmaximumdemand	      ratchetmd
rename circuitlength                  circlength
rename overheadlines   				  overline
rename undergroundcables			  undercable
rename transformers				      transform
rename aucoverhead				      auc_overline
rename aucunderground			  	  auc_undercable
rename auctransformers				  auc_transform
rename energynotsupplied	          ens	
rename priceofenergynotsupplied 	  price_ens 	
rename priceopex                      price_opex	
rename customernumbers                customers	

gen int tnsp = int(tnspyear/100)
gen int year = tnspyear - tnsp*100 + 2000
tab1 tnsp year	

label define tnsplab 21 "21.ENT: ElectraNet" 22 "22.PLK: Powerlink" ///
	23 "23.ANT: Ausnet Trans." 24 "24.TNT: TasNetworks Trans." ///
	25 "25.TRG: TransGrid" 																
label values tnsp tnsplab

label var tnsp 		  	 "Transmission Network Service Provider"
label var year 		  	 "Year (Financial or calendar as applicable)"
label var revenue   	 "Total Revenue ($'000)"
label var energy    	 "Energy (GWh)"		
label var maxdemand 	 "Maximum Demand (MW)"
label var ratchetmd      "Ratched Maximum Demand	(MW)"
label var circlength     "Circuit Length	(kms)"	
label var opex   		 "Opex ($'000)"
label var price_opex     "Price: Opex (Index 2006 = 1)"
label var overline 	  	 "Overhead Lines (MVAkms)"
label var undercable     "Underground Cables (MVAkms)"	
label var transform      "Transformers (MVA)"	
label var auc_overline   "AUC Overhead Lines ($'000)"
label var auc_undercable "AUC Underground Cables ($'000)"	
label var auc_transform  "AUC Transformers ($'000)"	
label var ens			 "Energy Not Supplied (MWh)"
label var price_ens      "Price of Energy Not Supplied ($/MWh)"
label var customers      "Customers (No.)"

gen byte state = 0
replace state = 5 if tnsp == 21
replace state = 4 if tnsp == 22 
replace state = 3 if tnsp == 23
replace state = 6 if tnsp == 24
replace state = 2 if tnsp == 25
label define statelab 1 "ACT" 2 "NSW" 3 "VIC" 4 "QLD" 5 "SA" 6 "TAS"
label values state statelab

replace ens = max(ens,minens)
gen double adjvens = min(ens * price_ens/1000, reliabilitycap * revenue)
gen double ropex = opex / price_opex

label var adjvens "Adjusted value of ENS ($'000)"
label var ropex "Real Opex ($'000 2006)"

* Save & summarise data

sort tnsp year

*export excel using Output/excel/test1.xlsx, firstrow(var) replace

xtset tnsp year

gen double mdindex = 1
replace mdindex = maxdemand / maxdemand[_n-1] * mdindex[_n-1] if year > 2006

format %12.0g revenue energy maxdemand ratchetmd circlength opex price_opex ///
	overline undercable transform auc_overline auc_undercable auc_transform ///
	ens price_ens customers   

describe
summarize `varlist'
misstable summarize `varlist'

* Create TNSP-specific files for use in Shazam

local shazvar year revenue energy ratchetmd customers circlength ens ///
	price_ens opex price_opex overline undercable transform auc_overline ///
	auc_undercable auc_transform maxdemand mdindex adjvens 
local datfiles ENTdata.csv PLKdata.csv ANTdata.csv TNTdata.csv TRGdata.csv 	

local j = 21	
foreach k of local datfiles {
	outsheet `shazvar' using Output/csv/`k' if tnsp == `j', comma replace
	local ++j
}

* Create pooled data for use in Shazam	


outsheet tnspyear revenue energy ratchetmd customers circlength ens ///
	price_ens opex price_opex overline undercable transform auc_overline ///
	auc_undercable auc_transform adjvens ///
	using Output/csv/TNSPdata.csv , comma replace

save Output/dta/tnspbench25-firm, replace	

* Create industry aggregates for use in Shazam

gen cost_ens = price_ens * ens
sort year tnsp

collapse (sum) revenue energy ratchetmd customers circlength ens cost_ens ///
	opex ropex overline undercable transform auc_overline ///
	auc_undercable auc_transform maxdemand adjvens, by(year) 

gen price_ens = cost_ens / ens
gen price_opex = opex / ropex

gen mdindex = 1
replace mdindex = maxdemand / maxdemand[_n-1] * mdindex[_n-1] if year > 2006

outsheet year revenue energy ratchetmd customers circlength ens ///
	price_ens opex price_opex overline undercable transform auc_overline ///
	auc_undercable auc_transform maxdemand mdindex adjvens ///
	using Output/csv/TINDdata.csv , comma replace

drop cost_ens
gen byte tnsp = 26

gen int tnspyear = tnsp*100 + (year - 2000)

format %12.0g `varlist'   
describe
summarize `varlist' 
misstable summarize `varlist' 

save Output/dta/tnspbench25-ind, replace
	
log close
exit	

